<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?php echo e(!empty($headerTitle) ? $headerTitle : "VPN"); ?></title>
  <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback">
  <link rel="stylesheet" href="<?php echo e(asset('assets/backend')); ?>/plugins/fontawesome-free/css/all.min.css">
  <link rel="stylesheet" href="<?php echo e(asset('assets/backend')); ?>/plugins/icheck-bootstrap/icheck-bootstrap.min.css">
  <!-- Select2 -->
  <link rel="stylesheet" href="<?php echo e(asset('assets/backend')); ?>/plugins/select2/css/select2.min.css">
  <!-- DataTables -->
  <link rel="stylesheet" href="<?php echo e(asset('assets/backend')); ?>/plugins/datatables-bs4/css/dataTables.bootstrap4.min.css">
  <link rel="stylesheet" href="<?php echo e(asset('assets/backend')); ?>/plugins/datatables-responsive/css/responsive.bootstrap4.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="<?php echo e(asset('assets/backend')); ?>/dist/css/adminlte.min.css">
  <!-- Custom style -->
  <link rel="stylesheet" href="<?php echo e(asset('assets/backend')); ?>/dist/css/custom.css">
  <!-- Toaster -->
  <link rel="stylesheet" href="<?php echo e(asset('assets/backend/css/toastify.min.css')); ?>" />
</head>
<body class="hold-transition sidebar-mini">
  <div class="wrapper">
    <!-- Navbar -->
    <?php if(
        !request()->routeIs('admin.loginView') && 
        !request()->routeIs('admin.password.forget') && 
        !request()->routeIs('admin.password.reset')
      ): ?>
        <?php echo $__env->make('backend.layouts.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php endif; ?>

    <!-- Sidebar -->
    <?php if(
        !request()->routeIs('admin.loginView') && 
        !request()->routeIs('admin.password.forget') && 
        !request()->routeIs('admin.password.reset')  
    ): ?>
        <?php echo $__env->make('backend.layouts.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php endif; ?>

    <?php echo $__env->yieldContent('content'); ?>

    <!-- Main Footer -->
    <?php if(
        !request()->routeIs('admin.loginView') && 
        !request()->routeIs('admin.password.forget') && 
        !request()->routeIs('admin.password.reset') 
    ): ?>
        <?php echo $__env->make('backend.layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php endif; ?>

  </div>
  <!-- REQUIRED SCRIPTS -->
  <!-- jQuery -->
  <script src="<?php echo e(asset('assets/backend')); ?>/plugins/jquery/jquery.min.js"></script>
  <script src="<?php echo e(asset('assets/backend')); ?>/plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
  <!-- DataTables  & Plugins -->
  <script src="<?php echo e(asset('assets/backend')); ?>/plugins/datatables/jquery.dataTables.min.js"></script>
  <script src="<?php echo e(asset('assets/backend')); ?>/plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
  <script src="<?php echo e(asset('assets/backend')); ?>/plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
  <script src="<?php echo e(asset('assets/backend')); ?>/plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
  <!-- AdminLTE App -->
  <script src="<?php echo e(asset('assets/backend')); ?>/dist/js/adminlte.min.js"></script>
  <!-- Select2 -->
  <script src="<?php echo e(asset('assets/backend')); ?>/plugins/select2/js/select2.full.min.js"></script>
  <!-- Toaster -->
  <script src="<?php echo e(asset('assets/backend/js/toastify-js.js')); ?>"></script>
  <script src="<?php echo e(asset('assets/backend/js/config.js')); ?>"></script>
  <script>
    // Show Toast
    window.onload = function() {
      <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        errorToast("<?php echo e($error); ?>");
      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

      <?php if(session('success')): ?>
        successToast("<?php echo e(session('success')); ?>");
      <?php endif; ?>
          
      <?php if(session('error')): ?>
        errorToast("<?php echo e(session('error')); ?>");
      <?php endif; ?>
    };
  </script>
  
  <script>
    $(function () {
      //Initialize Select2 Elements
      $('.select2').select2()
    });
  </script>
  
  <?php echo $__env->yieldPushContent('scripts'); ?>

</body>
</html>
<?php /**PATH C:\xampp\htdocs\VPNCodeCanyon\resources\views/backend/layouts/app.blade.php ENDPATH**/ ?>