<?php $__env->startSection('content'); ?>
  <div class="content-wrapper">
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6 pb-2 pb-sm-0">
            <h1 class="textWhite">Server List</h1>
          </div>
          <div class="col-sm-6 text-sm-right">
            <a href="<?php echo e(url('admin/servers/add')); ?>" class="btn btn-primary customButton">Add New Server</a>
          </div>
        </div>
      </div>
    </section>

    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <div class="col-md-12">
            <div class="card">
              <div class="card-body table-responsive p-3">
                <table id="serverTable" style="width: 100%;" class="table table-striped">
                  <thead>
                    <tr>
                      <th style="width: 80px">S. No.</th>
                      <th>Server Name</th>
                      <th>Country</th>
                      <th>VPN Username</th>
                      <th>VPN Password</th>
                      <th>Is Premium?</th>
                      <th>Status</th>
                      <th>Actions</th>
                    </tr>
                  </thead>
                  <tbody>

                  </tbody>
                </table>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
  $(document).ready(function() {
    var table = $('#serverTable').DataTable({
      processing: true,
      serverSide: true,
      ajax: {
        url: '<?php echo e(route('admin.servers.index')); ?>',
      },
      columns: [
        {
          data: null, 
          name: 'serial',
          orderable: false,
          searchable: false,
          render: function (data, type, full, meta) {
            return meta.row + 1 + meta.settings._iDisplayStart;
          }
        },
        { data: 'name', name: 'name' },
        { data: 'country_name', name: 'country_name' },
        { data: 'vpn_credentials_username', name: 'vpn_credentials_username' },
        { data: 'vpn_credentials_password', name: 'vpn_credentials_password' },
        {
            data: 'access_type',
            name: 'access_type',
            render: function (data, type, full, meta) {
                return data.charAt(0).toUpperCase() + data.slice(1);
            }
        },
        { data: 'status', name: 'status' },
        { data: 'actions', name: 'actions', orderable: false, searchable: false },
      ],
      responsive: true 
    });
    

  });
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('backend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\VPNCodeCanyon\resources\views/backend/admin/servers/index.blade.php ENDPATH**/ ?>