<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\Auth\RegisterController;
use App\Http\Controllers\Api\Auth\OTPController;
use App\Http\Controllers\Api\Auth\PasswordResetController;
use App\Http\Controllers\Api\Auth\LoginController;
use App\Http\Controllers\Api\Auth\LogoutController;
use App\Http\Controllers\Api\UserController;
use App\Http\Controllers\Api\DeviceController;
use App\Http\Controllers\Api\CountryController;
use App\Http\Controllers\Api\ServerController;
use App\Http\Controllers\Api\PackagePricingController;
use App\Http\Controllers\Api\PageController;
use App\Http\Controllers\Api\AdvertisementController;
use App\Http\Controllers\Api\AppSettingsController;
use App\Http\Controllers\Api\VpnPayloadController;
use App\Http\Controllers\Api\SimBridgeController;
use App\Http\Controllers\Api\ConnectionLogController;


// User Auth API
Route::post('device_register', [RegisterController::class, 'registerDevice']);
Route::post('user_registration', [RegisterController::class, 'registerUser']);
Route::post('send-otp', [OTPController::class, 'sendOtp']);
Route::post('verify-otp', [OTPController::class, 'verifyOtp']);
Route::post('password/reset', [PasswordResetController::class, 'resetPassword']);  
Route::post('login', [LoginController::class, 'login']);
Route::post('logout', [LogoutController::class, 'logout'])->middleware('auth:sanctum');

// Store FCM Token API
Route::post('devices/store-token', [DeviceController::class, 'storeToken']);

Route::middleware(['auth:sanctum'])->group(function() {
    // User API
    Route::get('user', [UserController::class, 'getUserInfo']);
    Route::post('user/update', [UserController::class, 'updateUserDetails']); 
    // Countries API
    Route::get('countries', [CountryController::class, 'getCountries']); 
    // Servers API
    Route::get('servers', [ServerController::class, 'getServers']); 
    // Pricing API
    Route::get('pricings', [PackagePricingController::class, 'getPricingList']);
    Route::post('package-details/save', [PackagePricingController::class, 'savePackageDetails']);

});


// Pages API
Route::get('pages', [PageController::class, 'getPages']);
Route::get('pages/{slug}/content', [PageController::class, 'getPageContentBySlug']);
// Advertisement API
Route::get('advertisement', [AdvertisementController::class, 'getAdvertisementData']);
// Settings API
Route::get('app-settings', [AppSettingsController::class, 'getAppSettingsData']);

// VPN Connection Management
Route::prefix('connection')->group(function() {
    Route::post('connect', [ConnectionLogController::class, 'connect']);
    Route::post('disconnect', [ConnectionLogController::class, 'disconnect']);
    Route::get('status', [ConnectionLogController::class, 'status']);
    Route::get('history', [ConnectionLogController::class, 'history']);
});

// VPN Payload Management
Route::prefix('payloads')->group(function() {
    Route::get('/', [VpnPayloadController::class, 'index']);
    Route::get('/available', [VpnPayloadController::class, 'getAvailable']);
    Route::post('/validate', [VpnPayloadController::class, 'validatePayload']);
});

// SIM Bridge API (requires special authentication)
Route::prefix('sim-bridge')->middleware(['auth:sanctum', 'sim.bridge'])->group(function() {
    Route::post('/register', [SimBridgeController::class, 'register']);
    Route::post('/update-status', [SimBridgeController::class, 'updateStatus']);
    Route::post('/ping', [SimBridgeController::class, 'ping']);
    Route::get('/stats', [SimBridgeController::class, 'getStats']);
});

// Admin API routes
Route::prefix('admin')->middleware(['auth:sanctum', 'role:admin'])->group(function() {
    // User Management
    Route::prefix('users')->group(function() {
        Route::post('/block', [UserController::class, 'blockUser']);
        Route::post('/unblock', [UserController::class, 'unblockUser']);
        Route::post('/trial', [UserController::class, 'setTrial']);
    });

    // Payload Management
    Route::prefix('payloads')->group(function() {
        Route::post('/', [VpnPayloadController::class, 'store']);
        Route::put('/{payload}', [VpnPayloadController::class, 'update']);
        Route::delete('/{payload}', [VpnPayloadController::class, 'destroy']);
        Route::post('/order', [VpnPayloadController::class, 'updateOrder']);
    });

    // SIM Bridge Management
    Route::prefix('sim-bridges')->group(function() {
        Route::get('/', [SimBridgeController::class, 'index']);
        Route::post('/weight', [SimBridgeController::class, 'updateWeight']);
        Route::delete('/{simBridge}', [SimBridgeController::class, 'destroy']);
    });
});

// Pages API
Route::get('pages', [PageController::class, 'getPages']);
Route::get('pages/{slug}/content', [PageController::class, 'getPageContentBySlug']);
// Advertisement API
Route::get('advertisement', [AdvertisementController::class, 'getAdvertisementData']);
// Settings API
Route::get('app-settings', [AppSettingsController::class, 'getAppSettingsData']);



















  