<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('vpn_payloads', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->json('config');
            $table->enum('status', ['live', 'blocked', 'slow'])->default('live');
            $table->integer('priority')->default(0);
            $table->timestamp('last_checked_at')->nullable();
            $table->integer('success_rate')->default(100);
            $table->string('type')->comment('cloud or tunnel');
            $table->json('metadata')->nullable()->comment('Additional configuration data');
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('vpn_payloads');
    }
};