<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('sim_bridges', function (Blueprint $table) {
            $table->id();
            $table->string('device_name');
            $table->string('sim_number');
            $table->string('ip_address');
            $table->bigInteger('data_used')->default(0);
            $table->timestamp('sim_expires_at');
            $table->integer('weight')->default(50)->comment('Load balancing percentage');
            $table->enum('status', ['active', 'inactive', 'expired'])->default('active');
            $table->json('device_info')->nullable()->comment('Additional device information');
            $table->timestamp('last_ping')->nullable();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('sim_bridges');
    }
};