<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Carbon\Carbon;

class SimBridge extends Model
{
    use HasFactory;

    protected $fillable = [
        'device_name',
        'sim_number',
        'ip_address',
        'data_used',
        'sim_expires_at',
        'weight',
        'status',
        'device_info',
        'last_ping'
    ];

    protected $casts = [
        'sim_expires_at' => 'datetime',
        'last_ping' => 'datetime',
        'device_info' => 'json',
        'data_used' => 'integer',
        'weight' => 'integer'
    ];

    public function isActive()
    {
        return $this->status === 'active' 
            && Carbon::now()->lessThan($this->sim_expires_at)
            && $this->last_ping->addMinutes(5)->greaterThan(Carbon::now());
    }

    public function scopeActive($query)
    {
        return $query->where('status', 'active')
                     ->where('sim_expires_at', '>', Carbon::now())
                     ->where('last_ping', '>', Carbon::now()->subMinutes(5));
    }
}